/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShield;
import net.minecraft.util.DamageSource;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.ability.AbstractAbility;
import noppes.npcs.api.mixin.entity.IEntityLivingBaseMixin;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class CombatHandler {
    public final Map<EntityLivingBase, Long> lastDamages = new HashMap<EntityLivingBase, Long>();
    public final Map<EntityLivingBase, Double> aggressors = new HashMap<EntityLivingBase, Double>();
    private int combatResetTimer = 0;
    private int delay = 10;
    private final EntityNPCInterface npc;
    public boolean onlyPlayers = false;
    public EntityLivingBase priorityTarget = null;

    public CombatHandler(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public boolean checkTarget() {
        if (this.aggressors.isEmpty() || this.npc.field_70173_aa % 10 != 0) {
            return false;
        }
        EntityLivingBase target = this.npc.func_70638_az();
        Double current = 0.0;
        if (this.isValidTarget(target)) {
            current = this.aggressors.get(target);
            if (current == null) {
                current = 0.0;
            }
        } else {
            target = null;
        }
        for (Map.Entry<EntityLivingBase, Double> entry : this.aggressors.entrySet()) {
            if (!(entry.getValue() > current) || !this.isValidTarget(entry.getKey())) continue;
            current = entry.getValue();
            target = entry.getKey();
        }
        return target == null;
    }

    public void damage(DamageSource source, double damageAmount) {
        Double oldValue;
        CustomNpcs.debugData.start((Object)this.npc);
        this.combatResetTimer = 0;
        Entity e = NoppesUtilServer.GetDamageSource(source);
        if (!(e instanceof EntityLivingBase)) {
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        EntityLivingBase attackingEntity = (EntityLivingBase)e;
        if (attackingEntity instanceof EntityPlayer) {
            if (((EntityPlayer)attackingEntity).field_71075_bZ.field_75098_d) {
                CustomNpcs.debugData.end((Object)this.npc);
                return;
            }
            this.onlyPlayers = true;
        }
        if (damageAmount <= 0.25) {
            damageAmount = 0.25;
        }
        double dist = this.npc.func_70011_f(attackingEntity.field_70165_t, attackingEntity.field_70163_u, attackingEntity.field_70161_v);
        double newValue = damageAmount;
        if (dist > 5.0 && dist < 32.0) {
            newValue *= 0.009259 * dist + 0.953704;
        }
        if (attackingEntity instanceof EntityPlayer) {
            newValue *= 1.1;
        }
        if (attackingEntity.func_184614_ca().func_77973_b() instanceof ItemShield || attackingEntity.func_184592_cb().func_77973_b() instanceof ItemShield) {
            newValue *= 1.2;
        } else if (source.func_76352_a() || source.func_82725_o()) {
            newValue *= 1.025;
        }
        if (this.npc.func_70638_az() != null && this.npc.func_70638_az().equals((Object)attackingEntity)) {
            newValue *= 1.05;
        }
        if ((oldValue = this.aggressors.get(attackingEntity)) == null) {
            oldValue = 0.0;
        }
        this.aggressors.put(attackingEntity, oldValue + newValue);
        this.lastDamages.put(attackingEntity, this.npc.field_70170_p.func_82737_E());
        if (this.priorityTarget == null) {
            this.priorityTarget = attackingEntity;
        }
        CustomNpcs.debugData.end((Object)this.npc);
    }

    public boolean isValidTarget(EntityLivingBase target) {
        return target != null && target.func_70089_S() && (!(target instanceof EntityPlayer) || !((EntityPlayer)target).field_71075_bZ.field_75102_a) && this.npc.isInRange((Entity)target, this.npc.stats.aggroRange) && this.npc.field_70170_p.field_73011_w.getDimension() == target.field_70170_p.field_73011_w.getDimension();
    }

    public void reset() {
        this.combatResetTimer = 0;
        this.delay = 10;
        this.onlyPlayers = false;
        this.aggressors.clear();
        this.lastDamages.clear();
        this.priorityTarget = null;
        this.npc.func_184212_Q().func_187227_b(EntityNPCInterface.Attacking, (Object)false);
    }

    private boolean shouldCombatContinue() {
        return this.npc.func_70638_az() != null && this.isValidTarget(this.npc.func_70638_az());
    }

    public void start() {
        this.combatResetTimer = 0;
        this.npc.func_184212_Q().func_187227_b(EntityNPCInterface.Attacking, (Object)true);
        for (AbstractAbility ab : this.npc.abilities.abilities) {
            ab.startCombat();
        }
    }

    public void update() {
        CustomNpcs.debugData.start((Object)this.npc);
        if (this.npc.isKilled()) {
            if (this.npc.isAttacking()) {
                this.reset();
            }
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        if (this.npc.func_70638_az() != null && !this.npc.isAttacking()) {
            this.start();
        }
        if (!this.shouldCombatContinue()) {
            if (this.combatResetTimer++ > 40) {
                this.reset();
            }
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        this.combatResetTimer = 0;
        if (this.aggressors.isEmpty()) {
            this.delay = 10;
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        --this.delay;
        if (this.delay > 0) {
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        this.delay = 10;
        ArrayList<EntityLivingBase> del = new ArrayList<EntityLivingBase>();
        double maxValue = Double.MIN_VALUE;
        this.priorityTarget = null;
        double maxDist = (double)this.npc.stats.aggroRange * 2.0;
        for (EntityLivingBase entity : this.aggressors.keySet()) {
            if (!this.isValidTarget(entity)) {
                del.add(entity);
                continue;
            }
            if (!Util.instance.canMoveEntityToEntity(this.npc, entity)) continue;
            double d = this.npc.func_70011_f(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (d > maxDist) {
                del.add(entity);
            }
            if (maxValue != Double.MIN_VALUE && !(this.aggressors.get(entity) >= maxValue)) continue;
            maxValue = this.aggressors.get(entity);
            this.priorityTarget = entity;
        }
        for (EntityLivingBase entity : del) {
            this.aggressors.remove(entity);
        }
        if (!(this.priorityTarget == null || this.npc.func_70638_az() != null && this.npc.func_70638_az().equals((Object)this.priorityTarget))) {
            this.npc.setPriorityAttackTarget(this.priorityTarget);
            this.npc.func_70661_as().func_75497_a((Entity)this.priorityTarget, 1.5);
            this.delay = 60;
        }
        CustomNpcs.debugData.end((Object)this.npc);
    }

    public boolean canDamage(DamageSource damagesource, float amount) {
        Entity entity = NoppesUtilServer.GetDamageSource(damagesource);
        if (!(entity instanceof EntityLivingBase)) {
            if (this.npc.ais.getMaxHurtResistantTime() != 0 && (float)this.npc.field_70172_ad > (float)this.npc.ais.getMaxHurtResistantTime() / 2.0f) {
                return amount > ((IEntityLivingBaseMixin)((Object)this.npc)).npcs$getLastDamage();
            }
            return true;
        }
        if (!this.lastDamages.containsKey(entity) || this.npc.ais.getMaxHurtResistantTime() == 0 || this.lastDamages.get(entity) + (long)(this.npc.ais.getMaxHurtResistantTime() / 2) < this.npc.field_70170_p.func_82737_E()) {
            this.lastDamages.put((EntityLivingBase)entity, this.npc.field_70170_p.func_82737_E());
            return true;
        }
        return false;
    }
}

